---
generated_at: 2026-01-21 10:30:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：7-Set filter.ps1.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **QTGMCフィルタのインストール前提**：環境依存の確認が必要
  2. **InputType=0/1の技術的意味**：QTGMCドキュメントの確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Source/Scripts/Set filter.ps1` 行1-17（スクリプト全体）
- E-02: `Source/Scripts/Set filter.ps1` 行2（ErrorActionPreference設定）
- E-03: `Source/Scripts/Set filter.ps1` 行4（Register-ObjectEvent）
- E-04: `Source/Scripts/Set filter.ps1` 行5-6（プロジェクト・スキャンタイプ取得）
- E-05: `Source/Scripts/Set filter.ps1` 行8-11（Interlaced判定・設定）
- E-06: `Source/Scripts/Set filter.ps1` 行12-15（Progressive判定・設定）
- E-07: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` 行8

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | AfterSourceLoadedイベントに登録する | E-03 | ○ |
| C-02 | ShortcutModule.gオブジェクトのイベントを使用 | E-03 | ○ |
| C-03 | ShortcutModule.pからアクティブプロジェクトを取得 | E-04 | ○ |
| C-04 | FirstOriginalSourceFileを使用 | E-04 | ○ |
| C-05 | MediaInfo.GetVideoでスキャンタイプを取得 | E-04 | ○ |
| C-06 | 'ScanType'パラメータを指定 | E-04 | ○ |
| C-07 | Interlacedの場合InputType=0を設定 | E-05 | ○ |
| C-08 | Progressiveの場合InputType=1を設定 | E-06 | ○ |
| C-09 | SetFilterメソッドを使用 | E-05, E-06 | ○ |
| C-10 | カテゴリ名'Field'を使用 | E-05, E-06 | ○ |
| C-11 | Preset="Medium"を使用 | E-05, E-06 | ○ |
| C-12 | $ErrorActionPreference = 'Stop'を設定 | E-02 | ○ |
| C-13 | イベントハンドラとして登録される | E-03 | ○ |
| C-14 | ソースファイル読み込み後に実行される | E-03 | ○ |
| C-15 | ファイル出力がない | E-01 | ○ |
| C-16 | データベース操作がない | E-01 | ○ |
| C-17 | ログ出力がない | E-01 | ○ |
| C-18 | QTGMCフィルタがAviSynth環境にインストールされている前提 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- QTGMCフィルタのインストール前提：スクリプトはQTGMCフィルタを使用しますが、インストールの有無をチェックしていません。インストールされていない場合のエラー処理についてはスクリプト内に記述がありません
  - 候補：StaxRipのフィルタ管理機能 / エラー発生時の動作テスト / インストールチェック処理の追加検討

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - フィルタ設定のみで破壊的な操作はない
- 1: 中リスク - QTGMCが未インストールの場合のエラー処理がない
- 1: 中リスク - MBAFF等の特殊なスキャンタイプに対応していない

## 6) レビュアーチェックリスト（最小）
- [ ] QTGMCフィルタがインストールされている環境で動作確認
- [ ] Interlaced/Progressive以外のスキャンタイプでの動作確認
- [ ] SetFilterで既存のFieldフィルタが上書きされることの確認
- [ ] Preset="Medium"がユースケースに適切か確認
